package Reldb.RelUserCode;

import org.reldb.rel.v0.types.*;
import org.reldb.rel.v0.types.builtin.*;
import org.reldb.rel.v0.types.userdefined.*;
import org.reldb.rel.v0.values.*;
import org.reldb.rel.v0.vm.Context;

public class op_FLOOR__RATIONAL {
	private static final ValueRational do_FLOOR(Context context, ValueRational a) {
		 
		// Returns the largest (closest to positive infinity) RATIONAL value that
		// is not greater than the argument and is equal to a mathematical
		// integer.
			return ValueRational.select(context.getGenerator(), Math.floor(a.doubleValue()));
	}

	public static final void execute(Context context) {
		ValueRational p0 = (ValueRational)context.pop();
		context.push(do_FLOOR(context, p0));
	}
}