package Reldb.RelUserCode;

import org.reldb.rel.v0.types.*;
import org.reldb.rel.v0.types.builtin.*;
import org.reldb.rel.v0.types.userdefined.*;
import org.reldb.rel.v0.values.*;
import org.reldb.rel.v0.vm.Context;

public class op_REMAINDER__RATIONAL_RATIONAL {
	private static final ValueRational do_REMAINDER(Context context, ValueRational f1, ValueRational f2) {
		          
		// Computes the remainder operation on two arguments as prescribed by the
		// IEEE 754 standard.
			return ValueRational.select(context.getGenerator(), Math.IEEEremainder(f1.doubleValue(),
					f2.doubleValue()));
	}

	public static final void execute(Context context) {
		ValueRational p1 = (ValueRational)context.pop();
		ValueRational p0 = (ValueRational)context.pop();
		context.push(do_REMAINDER(context, p0, p1));
	}
}